# -*- coding: utf-8 -*-
"""
Created on Tue Oct  5 12:01:05 2021

@author: reinoutubbink
"""
import numpy as np
import matplotlib.pyplot as plt

N = 710
NI = 60
L = 2e3
Fth = 70
res = 0.1
kT = 1.381e-23*300/1.602e-19

space1 = np.linspace(0,Fth-5*res,245)
space2 = np.linspace(Fth-4*res,Fth + NI*res,NI+5)
space3 = np.linspace(Fth +(NI+1)*res, L, N-NI-250)
space = np.concatenate((space1,space2,space3))

plt.close('all')
CELL1 = np.loadtxt('SS_HR_1M.csv', delimiter=',')
CELL2 = np.loadtxt('SS_HR_0.1M.csv', delimiter=',')
CELL3 = np.loadtxt('SS_HR_0.01M.csv', delimiter=',')
plt.figure('Electrostatic potential') 
fig = plt.figure('Electrostatic potential')
ax = fig.add_subplot(1, 1, 1)
ax.set_facecolor('#F1EBFF')                      #plots electrostatice potential throughout the device
ax.plot(space[:315],CELL1[5*N:5*N+315], color='black') #315
ax.plot(space[:315],CELL2[5*N:5*N+315], color='dimgray')
ax.plot(space[:315],CELL3[5*N:5*N+315], color='darkgray')
plt.margins(x=0.01,y=0.1)
fig = plt.gcf()
fig.set_size_inches(10, 7, forward=True)
plt.xlabel('Distance (nm)', size = '15')
plt.ylabel('Electrostatic potential (V/m)', size = '15')
ax.tick_params(length=10, width=3,labelsize='25')
ax.margins(x=0.01,y=0.1)
#ax.legend(['1 M','0.1M','0.01M'],loc = 3, prop={'size': 20})
fig2 = plt.figure('Concentrations')
ax2 = fig2.add_subplot(1, 1, 1)
ax2.set_facecolor('#F1EBFF')
ax2.plot(space[1:315],CELL1[1:315]/6e26,'navy')
ax2.plot(space[1:315],CELL2[1:315]/6e26,'blue')
ax2.plot(space[1:315],CELL3[1:315]/6e26,'cornflowerblue')
#ax2.plot(space[1:100],CELL1[N+1:N+100]/6e26,'black')
#ax2.plot(space[1:100],CELL2[N+1:N+100]/6e26,'dimgray')
#ax2.plot(space[1:100],CELL3[N+1:N+100]/6e26,'darkgray')
#plt.plot(space[1:-1],CELL1[1:41]/6e26,'blue')
#plt.plot(space[1:-1],CELL2[1:41]/6e26,'royalblue')
#plt.plot(space[1:-1],CELL3[1:41]/6e26,'cornflowerblue')
plt.xlabel('Distance (nm)', size = '15')
plt.ylabel('Cation concentration (M)', size = '15')
ax2.tick_params(length=10, width=3,labelsize='25')
plt.ylim(0,0.8)
ax2.margins(x=0.01,y=0.1)
fig = plt.gcf()
fig.set_size_inches(10, 7, forward=True)
#plt.legend(['1 M','0.1M','0.01M'],loc = 2, prop={'size': 20})
plt.show()
#plt.savefig('image.png', bbox_inches='tight',pad_inches = 0)
#%%
concentrations = [1,0.1,0.01]
dopings = [CELL1[20]/6e26,CELL2[20]/6e26,CELL3[20]/6e26]
drops = [CELL1[5*N+20]/CELL1[5*N],CELL2[5*N+20]/CELL2[5*N],CELL3[5*N+20]/CELL3[5*N]]
dropsT = []
CELLs = [CELL1,CELL2,CELL3]
for i in range(3):
    cf = CELLs[i][N+20]/6e26*2
    #cf = dopings[i]/0.5 + concentrations[i]
    dropsT.append(-kT*np.log(cf/concentrations[i])/CELLs[i][5*N])
    
fig3 = plt.figure("trends")
ax3 = fig3.add_subplot(1, 1, 1)
ax4 = ax3.twinx()
ax3.scatter(concentrations, dopings, color='k')
ax4.scatter(concentrations, drops, color='b')
#ax4.scatter(concentrations, dropsT, color='cornflowerblue')
ax3.plot(concentrations, dopings, color='k')
ax4.plot(concentrations, drops, color='b')
#ax4.plot(concentrations, dropsT, color='cornflowerblue')
ax3.set_xscale('log')
ax3.set_xlim([0.005,2])
ax3.set_ylim([0.3,0.55])
ax3.tick_params(length=10, width=3,labelsize='25')
ax4.tick_params(length=10, width=3,labelsize='25',labelcolor='b')
ax2.margins(x=0.01,y=0.1)
fig = plt.gcf()
fig.set_size_inches(10, 7, forward=True)

#from matplotlib import colors

#print(colors.to_rgba('blue'))

#%%

c0 = 1*6e26
c1 = []
phi = []
c_expected = []
CELL = CELL1
for i in range(5,N-5):
    if i < 251:
        c1.append(2*CELL[N+i]/c0)
    else:
        c1.append(CELL[N+i]/c0)        
    phi.append(CELL[5*N+i])
    c_expected.append(np.exp(-phi[-1]/kT))

plt.figure('theory')
plt.plot(c1)
plt.plot(c_expected)
